/*->c.calendar */

#include <stdafx.h>
#include "resource.h"

#include <stdio.h>
#include <ctype.h> 
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <locale.h>


#include "os.h"
#include "wimp.h"
#include "wos.h"
#include "bbc.h"
#include "font.h"
#include "flex.h"
#include "werr.h"


#include "etc.h"
#include "task.h"
#include "deb.h"
#include "err.h"
#include "temp.h"
#include "poll.h"
#include "colour.h"
#include "filetype.h"
#include "save.h"
#include "key.h"
#include "wmf.h"
#include "osunits.h"
#include "appinfo.h"
#include "oshelp.h"

#include "constants.h"

#include "calendar.h"




int    version=104;
int    compatability=0;
char * datestring="(15-March-2005)";


/********************************************************************************/

#define TCALENDAR 0x100
#define TYEAR     0x101
#define TDATES    0x102


#define EREPDEC  0x101
#define EREPNEG  0x102
#define EBADVAL  0x103


#define EMISS    0x104
#define ECOMM    0x105



static errtag errortable[]=
{
 EREPDEC,"{EREPDEC}",
 EREPNEG,"{EREPNEG}",
 EBADVAL,"{EBADVAL}",

 EMISS,"{EMISS}",
 ECOMM,"{ECOMM}",


 ELAST ,""
};


static errlink errorlink;




static templates temptable[]=
{
 TCALENDAR,1,0,"Calendar",
 TYEAR,1,0,"Year",
 TDATES,1,0,"Dates",

 TLAST,  0,0,""
};


static templink templatelink;



#define TEXTTYPE 0xFFF
#define WMFTYPE  0x100
#define EMFTYPE  0x101
#define PMFTYPE  0x102

static filetypelink filetypelink;

static filetypetag filetypetable[]=
{
 0xFFF,"txt","Text (*.txt)",
 0xFFD,NULL,"Data (*.dat)",
 0x101,"emf","Enhanced metafile (*.emf)",
 0x100,"wmf","Windows metafile (*.wmf)",
 0x102,"wmf","Placeable metafile (*.wmf)",
 FTDEFLT,"dat","Data (*.dat)",

 FTLAST,NULL,NULL,
};




os_error * resinit(char * resources)
{
 os_error * err;

          err=adderrortable(errortable,&errorlink);
 if(!err) err=addtemplates(resources,"Templates",temptable,&templatelink);
 if(!err) err=addfiletypetable(filetypetable,&filetypelink);
 return(err);
}


/*****************************************************************************/





                            /* 'magic' threshold numbers */
#define  RTHRESH   578074
#define  BTHRESH   640135
                            /* set default - British calendar */
int   Threshold  = BTHRESH;
char  British    = 1;
                            

char * monthstring[12]={"January","February","March","April","May","June",
"July","August","September","October","November","December"};




                                                

/* returns day number of dd/mm/yy counting from 1/2/0000  */

int dmy_to_dn(char dd, char mm, int yy)
{     
 int dn;

 if(mm<3)
 {
  yy--;
  mm+=10;
 }
 else mm-=2;

 dn=365*yy+yy/4+367*mm/12+dd;

 return((dn<Threshold)?dn-2:dn-yy/100+yy/400);
}



struct tm *easter(int year)
{          /* works out date of Easter Sunday for 'year'  */

     static struct tm easterdate;
     char fstwkd=(char)(dmy_to_dn(1,3,year) % 7);
     char golden=(char)(year%19 + 1);
     char d;

     easterdate.tm_year=year;
     if (year<Threshold/365) {   /* Julian calendar */
       d=(char)((19*golden+2)%30);
       d=(char)(d+(d<5)*24-(d>=5)*6);
     } else {                    /* Gregorian calendar */
       int century=year/100-15;
       int c=3+3*century/4-(century-(century-2)/25)/3;
       d=(char)((19*golden+c)%30);
       if (golden> 11 && d>27) d--;
       if (golden<=11 && d==29) d=28;
     }

     d+=21;          /* Paschal moon d days after March 21st */
     easterdate.tm_mday=d+7-(d+fstwkd-1)%7;
     if (easterdate.tm_mday > 31) {   
       easterdate.tm_mday-=31;        
       easterdate.tm_mon=3;
     } else
       easterdate.tm_mon=2;

     return &easterdate;
}




#define EASTER 1
#define XMAS   2
#define XTODAY 3


typedef struct daystr
{
 char dn;
 char type;
 char x;
 char y;
} daystr;


typedef struct monthstr
{
 int    days;            /* how many days */
 daystr day[31];
 int    x;
 int    y;
} monthstr;


typedef struct yearstr
{
 wimp_w    handle;
 wimp_w    pane;
 wimp_w    dates;
 int       year;
 int       w;
 monthstr  month[12];
} yearstr;


yearstr * years;
int       yearn;       /* how many years there are */





/* construct calendar for one month;
       x is the horizontal starting posn on the virtual screen, 
          used to assemble 3 calendars for display      */


void calendar(char mon,int year,monthstr * mz)
{  
 char day;
 char offset;
 int  t=dmy_to_dn(1,mon,year);
 char monlen=(char)(dmy_to_dn(1,(char)(mon+1),year)-t);
 char fstwkd=(char)(t % 7);  
 int  x;
 int  y;   
 
 mz->days=monlen;

 if(fstwkd)
 {   
  x=fstwkd-1;
  y=0;
 }
 else 
 {
  y=-1;
  x=0;
 }

 for(day=1;day<=monlen;day++)
 {
  if((day-1+fstwkd)%7==0)
  {
   x=0;
   y++;
  }
  else x++;

  offset=(char)(British?11*(monlen==19 && day>2):10*(monlen==21 && day>4));

  mz->day[day-1].type=0;
  mz->day[day-1].x=(char)x;
  mz->day[day-1].y=(char)y;
  mz->day[day-1].dn=(char)(day+offset);
 }
}


void setupyear(yearstr * yz,int year)
{
 int mon;
 struct tm * ed;
 time_t      timex;

 yz->year=year;
 ed=easter(year);
 for(mon=0;mon<12;mon++) calendar((char)(mon+1),year,&yz->month[mon]);
 yz->month[ed->tm_mon].day[ed->tm_mday-1].type=EASTER;
 yz->month[11].day[25-1].type=XMAS;

 timex=time(NULL);
 ed=localtime(&timex);

 if(ed->tm_year+1900==year) 
   yz->month[ed->tm_mon].day[ed->tm_mday-1].type=XTODAY;

 writeiconf(yz->pane,IDC_YEAR_YEAR,"%d",year);
}

/*****************************************************************************/

#define XPIXBORDER 2
#define YPIXBORDER 2

static os_error * yearclose(wimp_w handle,uservalue yn);

#define DDY 24
#define DDX 12 


#define MONTOP    8
#define MONBOT    8
#define MONLEFT   8
#define MONRIGHT  8
#define MONDELTAX 16
#define MONDELTAY 32
#define MONWIDTH  7*3*DDX
#define MONHEIGHT 8*DDY



int getyear(wimp_w handle)
{
 int i;

 for(i=0;i<yearn;i++)
  if(years[i].handle==handle) return(i);

 return(-1);
}


int getyearpane(wimp_w handle)
{
 int i;

 for(i=0;i<yearn;i++)
  if(years[i].pane==handle) return(i);

 return(-1);
}



char * daystrn[32]=
{
 "  0",
 "  1",
 "  2",
 "  3",
 "  4",
 "  5",
 "  6",
 "  7",
 "  8",
 "  9",
 " 10",
 " 11",
 " 12",
 " 13",
 " 14",
 " 15",
 " 16",
 " 17",
 " 18",
 " 19",
 " 20",
 " 21",
 " 22",
 " 23",
 " 24",
 " 25",
 " 26",
 " 27",
 " 28",
 " 29",
 " 30",
 " 31"
};




static char * dayname[7]=
{
 "S",
 "M",
 "Tu",
 "W",
 "Th",
 "F",
 "S"
};










#define CHWIDTH    16
#define CHWIDTH2   28


#define FONTCODE  26
#define COLCODE   18
#define COLCODE2  19




static void cxprint(int xlo,int xhi,int flags,int y,char * p)
{
 int            x;

 if(flags==1) /* right */
 {
  font_align(FA_RIGHT|FA_BASELINE);
  x=xhi;
 }
 else
 if(flags==2) /* centre */
 {
  x=(xhi-xlo);
  x/=2;
  x=xlo+x;
  font_align(FA_CENTRE|FA_BASELINE);
 }
 else
 {
  x=xlo;
  font_align(FA_LEFT|FA_BASELINE);
 }

 font_paint(p,font_ABS|font_OSCOORDS|font_BACKBLEND,x,y);
}







#define DDYL desklead




static os_error * redrawyearsubnew(wimp_redrawstr * redrawstr,int more,int yn)
{
 int         oy;
 int         ox;
 int         ylo;
 int         yhi;
 int         xlo;
 int         xhi;
 int         n;
 int         y;
 int         x;
 yearstr  *  yz;
 monthstr  * mz;
 daystr    * dz;
 int         mon;
 char     *  p;
 font_metric metric;
 font        deskfonthandle;
 int         desklead;
 int         deskheight;



 yz=&years[yn];

 while(more)
 {
  font_find("Arial",0,8*16,0,0,&deskfonthandle);
  font_setcolour(deskfonthandle,PALTRANSPARENT,PALBLACK,0);
  font_getmetric(&metric);

  desklead=ypix2os(metric.ascent);
  deskheight=ypix2os(metric.height);

  
  ox=redrawstr->box.x0-redrawstr->scx;
  oy=redrawstr->box.y1-redrawstr->scy;

  ylo=-(redrawstr->g.y1-oy);            /* small number, top of window */
  yhi=-(redrawstr->g.y0-oy);            /* bigger, bottom of window */
  xlo=(redrawstr->g.x0-ox);
  xhi=(redrawstr->g.x1-ox);


  for(mon=0;mon<12;mon++)
  {
   mz=&yz->month[mon];

   if((mz->x+MONWIDTH)>=xlo && mz->x<=xhi)
   {
    if((mz->y+MONHEIGHT)>=ylo && mz->y<=yhi)
    {
     y=mz->y;
     x=mz->x;


     cxprint(x+ox,MONWIDTH+x+ox,2,oy-y-DDYL,monthstring[mon]);

     for(n=0;n<7;n++)
     {
      cxprint(x+ox+n*3*DDX,x+ox+(n+1)*3*DDX,1,oy-y-DDY-DDYL,dayname[n]);
     }

     dz=&mz->day[0];

     for(n=0;n<mz->days;n++)
     {
      if(dz->type)
      {
       if(dz->type==XTODAY) wimp_setcolour(WIMPGREEN);
       else                 wimp_setcolour(WIMPYELLOW);

       bbc_rectanglefill(x+ox+dz->x*3*DDX+DDX,oy-y-(dz->y+2)*DDY,2*DDX,-DDY);
      }

      p=daystrn[dz->dn];
      while(*p==' ') p++;

      if(*p)
      {
       cxprint(x+ox+dz->x*3*DDX,x+ox+(dz->x+1)*3*DDX,1,oy-y-(dz->y+2)*DDY-DDYL,p);
      }
      dz++;
     }
    }
   }
  } 

  font_lose(deskfonthandle);

  wimp_get_rectangle(redrawstr,&more);
 }

 return(NULL);
}











static os_error * yeardraw(wimp_w handle,uservalue yn)
{
 os_error       * err;
 wimp_redrawstr   redrawstr;
 int              more;

 redrawstr.w=handle;

                  err=wimp_redraw_wind(&redrawstr,&more);
 if(!err && more) err=redrawyearsubnew(&redrawstr,more,yn);

 return(err);
}



void calcmoncoords(int yn)
{
 int       w;
 int       h;
 int       mon;
 int       x;
 int       y;
 windowstr window;

 getw(years[yn].dates,&window);

 w=(window.x1-window.x0)-(MONLEFT+MONRIGHT);

 if(w>=(11*MONDELTAX+12*MONWIDTH)) w=12;
 else
 if(w>=(5*MONDELTAX+6*MONWIDTH)) w=6;
 else
 if(w>=(3*MONDELTAX+4*MONWIDTH)) w=4;
 else
 if(w>=(2*MONDELTAX+3*MONWIDTH)) w=3;
 else
 if(w>=(1*MONDELTAX+2*MONWIDTH)) w=2;
 else                            w=1;


 h=12/w;

 for(mon=0;mon<12;mon++)
 {
  x=(mon % w);
  y=mon/w;
  years[yn].month[mon].x=MONLEFT+x*(MONWIDTH+MONDELTAX);
  years[yn].month[mon].y=MONTOP+y*(MONHEIGHT+MONDELTAY);
 }

 if(years[yn].w!=w)
 {
  extent(years[yn].dates,0,-(MONTOP+MONBOT+h*MONHEIGHT+(h-1)*MONDELTAY),
                          MONLEFT+MONRIGHT+w*MONWIDTH+(w-1)*MONDELTAX,0); // was w=6
  refreshwindow(years[yn].dates);
  years[yn].w=w;
 }
}




os_error * yearpaneopen(int i,wimp_openstr * open)
{
 os_error   * err;
 wimp_openstr o;
 int          h;
 windowstr    window;
 int          x0;
 int          x1;
 int          y0;
 int          y1;

 err=geto(years[i].pane,&window);
 h=yos2pix(window.y1-window.y0);

 x0=xpix2os(xos2pix(open->box.x0)+XPIXBORDER);
 x1=xpix2os(xos2pix(open->box.x1)-XPIXBORDER);
 y1=ypix2os(yos2pix(open->box.y1)); 
 y0=ypix2os(yos2pix(y1)-h);

 o.w=years[i].pane;
 o.box.x0=x0;
 o.box.y0=y0;   
 o.box.x1=x1;
 o.box.y1=y1;
 o.x=window.scx;       
 o.y=window.scy;
               
 o.behind=(wimp_w)-3; //open->behind;

 err=wimp_open_wind_ex(&o);

 return(err);
}


void yeardatesopen(int i,wimp_openstr * open)
{
 wimp_openstr o;
 int          h;
 windowstr    window;
 int          x0;
 int          x1;
 int          y0;
 int          y1;

 geto(years[i].pane,&window);
 h=yos2pix(window.y1-window.y0);

 getw(years[i].dates,&window);

 x0=xpix2os(xos2pix(open->box.x0)+XPIXBORDER);
 x1=xpix2os(xos2pix(open->box.x1)-XPIXBORDER);
 y1=ypix2os(yos2pix(open->box.y1)-h-2*YPIXBORDER); 
 y0=ypix2os(yos2pix(open->box.y0)+YPIXBORDER);

 o.w=years[i].dates;
 o.box.x0=x0;
 o.box.y0=y0;   
 o.box.x1=x1;
 o.box.y1=y1;
 o.x=window.scx;       
 o.y=window.scy;
               
 o.behind=(wimp_w)-3; //open->behind;

 wimp_open_wind_ex(&o);
}





/* called by wimps to open buffer window */
/* we open tools pane on top             */

static os_error * yearopen(wimp_w handle,uservalue yn,wimp_openstr * o)
{
 cprintf("yearopen main=%x pane=%x dates=%x",handle,years[yn].dates,years[yn].pane);

 yearpaneopen(yn,o);
 yeardatesopen(yn,o);
 calcmoncoords(yn);

 return(NULL);
 USE(handle);
}



void yearpopup(int yn)
{
 os_error      * err;
 wimp_openstr    o;
 windowstr       window;

 err=getw(years[yn].pane,&window);
 
 o.w=years[yn].handle;
 o.box.x0=0;
 o.box.x1=o.box.x0+MONLEFT+MONWIDTH*4+MONDELTAX*3+MONRIGHT+vscrlbar+8*xpix2os(XPIXBORDER);
 o.box.y1=cvdu.screeny;
 o.box.y0=o.box.y1-(MONTOP+MONHEIGHT*3+MONDELTAY*2+MONBOT)-2*hscrlbar-(window.y1-window.y0)-4*ypix2os(YPIXBORDER);
 o.y=0;
 o.x=0;
 o.behind=(wimp_w)-1;

 centerwindow3(&o,yn);

 wimp_open_wind(&o);

 yearopen(years[yn].handle,yn,&o);
}



/********************************************************************************/


static os_error * csaveoption(wimp_w handle,int opt,int * type,TCHAR * name,int maxsize)
{
 switch(opt)
 {
  case 0:
         *type=TEXTTYPE;
         break;

  case 1:
         *type=WMFTYPE;
         break;

  case 2:
         *type=PMFTYPE;
         break;

  case 3:
         *type=EMFTYPE;
         break;
 }


 return(NULL);
 USE(handle);
 USE(name);
 USE(maxsize);
}




static saveoptionstr saveoptions[]=
{
 "Text file (*.txt)",            csaveoption,
 "Metafile (*.wmf)",             csaveoption,
 "Placeable metafile (*.wmf)",   csaveoption,
 "Enhanced metafile (*.emf)",    csaveoption,
};


static int csaveopt;

static int currentyear;








static os_error * saveastext(int year,char * filename)
{
 FILE      * fp;
 int         mon;
 struct tm * ed;
 monthstr    month[12];
 monthstr  * mz;
 daystr    * dz;
 int         y;
 int         x;
 int         n;
 char      * p;



 ed=easter(year);
 for(mon=0;mon<12;mon++) calendar(mon+1,year,&month[mon]);
 month[ed->tm_mon].day[ed->tm_mday-1].type=EASTER;
 month[11].day[25-1].type=XMAS;


 fp=fopen(filename,"wb");
 if(fp)
 {
  fprintf(fp,"%d\r\n",year);


  for(mon=0;mon<12;mon++)
  {
   mz=&month[mon];


   fprintf(fp,"%s\r\n",monthstring[mon]);

   for(n=0;n<7;n++)
   {
    fprintf(fp,"\t%s",dayname[n]);
   }             

   fprintf(fp,"\r\n");


   dz=&mz->day[0];
   y=0;
   x=-1;

   for(n=0;n<mz->days;n++)
   {
    while(y<dz->y)
    {
     fprintf(fp,"\r\n");
     y++;
     x=-1;
    }

    while(x<dz->x)
    {
     fprintf(fp,"\t");
     x++;
    }

    p=daystrn[dz->dn];
    while(*p==' ') p++;

    fprintf(fp,"%s",p);

    dz++;
   }

   fprintf(fp,"\r\n");
  }
  fclose(fp);
 }

 return(NULL);

}





#define DTXY   (30)
#define DTXX   ((DTXY*6)/10)


#define DDAYW  (3*DTXX)
#define DDAYH  (5*DTXY)/4


#define DXMON  DDAYW
#define DYMON  DDAYH

#define DMONW  (7*DDAYW+DXMON)
#define DMONH  (8*DDAYH+DYMON)

#define DWN w
#define DHN (12/w)




static os_error * drawyear(int year,int w)
{
 int         mon;
 struct tm * ed;
 monthstr    month[12];
 monthstr  * mz;
 daystr    * dz;
 int         x;
 int         y;
 int         n;
 int         ysize;
 char      * p;
 font        deskfonthandle;

// font_getstandardfont(0,&deskfonthandle);

 font_find("Arial",0,(DTXY*16*72)/OSYRES,0,0,&deskfonthandle);
 font_setcolour(deskfonthandle,PALTRANSPARENT,PALBLACK,0);

 ed=easter(year);
 for(mon=0;mon<12;mon++) calendar(mon+1,year,&month[mon]);
 month[ed->tm_mon].day[ed->tm_mday-1].type=EASTER;
 month[11].day[25-1].type=XMAS;

 ysize=DHN*DMONH;

// vectextsize(DTXX,DTXY,&diag);
// vectextcolour(0x0,0xFFFFFF00,&diag);

 for(mon=0;mon<12;mon++)
 {
  mz=&month[mon];

  y=(mon/DWN)*DMONH+DYMON/2;
  x=(mon % DWN)*DMONW+DXMON/2;

  cxprint(x,x+DMONW-DXMON,2,y+DTXY,monthstring[mon]);
  y+=DDAYH;

  for(n=0;n<7;n++)
  {
   cxprint(x+n*DDAYW,x+(n+1)*DDAYW,1,y+DTXY,dayname[n]);
  }

  y+=DDAYH;
  dz=&mz->day[0];

  for(n=0;n<mz->days;n++)
  {
   p=daystrn[dz->dn];
   while(*p==' ') p++;

   if(*p)
   {
    cxprint(x+dz->x*DDAYW,x+(dz->x+1)*DDAYW,1,y+dz->y*DDAYH+DTXY,p);
   }

   dz++;
  } 
 }

 font_lose(deskfonthandle);

 return(NULL);
}









static os_error * saveaswmf(char * name)
{
 os_error * err;
 metahandle        handle;
 int        maxx;
 int        maxy;

 maxx=years[currentyear].w*DMONW;
 maxy=(12/years[currentyear].w)*DMONH;

 err=openwmf(0,maxx,maxy,&handle);
 if(!err)
 {
  err=drawyear(years[currentyear].year,years[currentyear].w);
  err=closewmf(err,handle,name);
 }

 return(err);
}



static os_error * saveaspmf(char * name)
{
 os_error * err;
 metahandle handle;
 int        maxx;
 int        maxy;

 maxx=years[currentyear].w*DMONW;
 maxy=(12/years[currentyear].w)*DMONH;

 err=openpmf(0,maxx,maxy,&handle);
 if(!err)
 {
  err=drawyear(years[currentyear].year,years[currentyear].w);
  err=closepmf(err,handle,name,0,maxx,maxy,0,120);
 }

 return(err);
}



static os_error * saveasemf(char * name)
{
 os_error * err;
 metahandle handle;
 char       desc[64];
 int        maxx;
 int        maxy;

 maxx=years[currentyear].w*DMONW;
 maxy=(12/years[currentyear].w)*DMONH;

 sprintf(desc,"Calendar\0%d\0",years[currentyear].year);

 err=openemf(name,0,maxx,maxy,&handle,desc);
 if(!err)
 {
//  bbc_move(0,0);bbc_draw(0,maxy);bbc_draw(maxx,maxy);bbc_draw(maxx,0);
//  bbc_draw(0,0);

  err=drawyear(years[currentyear].year,years[currentyear].w);
  err=closeemf(err,handle);
 }

 return(err);
}





static os_error * csavefile(char * name,int type)
{
 os_error * err;

 err=NULL;

 switch(type)
 {
  case TEXTTYPE:
                err=saveastext(years[currentyear].year,name);
                break;

   case WMFTYPE:
                err=saveaswmf(name);
                break;

   case PMFTYPE:
                err=saveaspmf(name);
                break;

   case EMFTYPE:
                err=saveasemf(name);
                break;
 }

 return(err);
}


static os_error * yearpaneicon(wimp_w handle,uservalue yn,wimp_mousestr * m)
{
 TCHAR  savepath[MAX_PATH];
 static int state;

 cprintf("yearpaneicon %d bbits=%d",m->i,m->bbits);


 currentyear=yn;

 if(((m->i==IDC_YEAR_DOWN && m->bbits==0x4) || (m->i==IDC_YEAR_UP && m->bbits==0x1))
     && years[yn].year>1)
 {
  setupyear(&years[yn],years[yn].year-1);
  refreshwindow(years[yn].dates);
 }
 else
 if((m->i==IDC_YEAR_UP && m->bbits==0x4) || (m->i==IDC_YEAR_DOWN && m->bbits==0x1))
 {
  setupyear(&years[yn],years[yn].year+1);
  refreshwindow(years[yn].dates);
 }
 else
 if(m->i==IDC_YEAR_SAVE)
 {
  setsaveoptions(sizeof(saveoptions)/sizeof(saveoptionstr),saveoptions,&csaveopt);
  *savepath=0;
  strcpy(savepath,"calendar");
  opensaveparent(savepath,NITEM(savepath),TEXTTYPE,csavefile,years[yn].handle);
 }
 else
 if(m->i==IDC_YEAR_INFO)
 {
  infowindow(years[yn].handle,version,datestring);

 }
 else
 if(m->i==IDC_YEAR_HELP)
 {
  helptopic(years[yn].handle,"<HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\Calendar.exe\\Path>\\Calendar.chm>");
 }

 return(NULL);
 USE(handle);
}


static os_error * keyyear(wimp_w handle,uservalue yn,int icon,int * key)
{
 int    year;
 int    ch;
 char * p;

 ch=*key;

// cprintf("keyyear icon=%d key=%d",icon,ch);


 if(ch==13)
 {
  iconaddr(years[yn].pane,IDC_YEAR_YEAR,&p);

//  cprintf("year %s",p);

  if(sscanf(p,"%d",&year)==1)
  {
   if(year>=1 && year!=years[yn].year)
   {
    setupyear(&years[yn],year);
    refreshwindow(years[yn].handle);
   }
  }
  *key=-1;
 }
 else
 if(ch==27)
 {
  yearclose(years[yn].handle,yn);
  *key=-1;
 }
 else
 {
  scrollkey(years[yn].dates,key);
 }

 return(NULL);

 USE(icon);
 USE(handle);
}



static os_error * keymain(wimp_w handle,uservalue yn,int icon,int * key)
{

 cprintf("keymain");

 return(scrollkey(years[yn].dates,key));
 
 USE(icon);
 USE(handle);
}













#ifdef NEVER

static os_error * yearicon(int handle,int yn,wimp_mousestr * m)
{
 int        x;
 int        y;
 int        mx;
 int        my;
 int        n;
 yearstr *  yz;
 monthstr * mz;
 daystr   * dz;
 int        mon;
 int        dsum;
 windowstr  window;

 getw(years[yn].handle,&window);

 x=m->x-window.bx;
 y=window.by-m->y;

 if(m->bbits==2)
 {
  currentyear=yn;
 }
 else
 {
  yz=&years[yn];
  dsum=0;

  for(mon=0;mon<12;mon++)
  {
   mz=&yz->month[mon];

   if(x<=(mz->x+MONWIDTH) && x>=mz->x)
   {
    if(y<=(mz->y+MONHEIGHT) && y>=mz->y)
    {
     my=mz->y;
     mx=mz->x;
     dz=&mz->day[0];

     for(n=0;n<mz->days;n++)
     {
      if(x<=(mx+(dz->x+1)*3*DDX) && x>=(mx+dz->x*3*DDX) &&
         y<=(my+(dz->y+3)*DDY)   && y>=(my+(dz->y+2)*DDY)  )
      {
       struct tm timem;

       timem.tm_sec=0;
       timem.tm_min=0;
       timem.tm_hour=0;
       timem.tm_mday=dz->dn;
       timem.tm_mon=mon;
       timem.tm_year=yz->year;
       timem.tm_wday=dz->x;
       timem.tm_yday=dsum+n;
       timem.tm_isdst=0;

     /*  err=newtoday(&timem);
       if(err) report(err); */

       return(NULL);
      }
      dz++;
     }
    }
   }
   dsum+=mz->days;
  } 
 }
 return(NULL);
 USE(handle);
}

#endif

static os_error * yearclose(wimp_w handle,uservalue yn)
{

 remclickevent(yearpaneicon,years[yn].pane,yn);
 remkeyevent(keyyear,years[yearn].pane,yn);
 remkeyevent(keymain,years[yearn].handle,yearn);
 remcloseevent(yearclose,years[yn].handle,yn);
 remopenevent(yearopen,years[yn].handle,yn);
 remredrawevent(yeardraw,years[yn].handle,yn);

 if(years[yn].pane)
 {
  wimp_close_wind(years[yn].pane);
  wimp_delete_wind(years[yn].pane);
 }

 if(years[yn].dates)
 {
  wimp_close_wind(years[yn].dates);
  wimp_delete_wind(years[yn].dates);
 }

 if(years[yn].handle)
 {
  wimp_close_wind(years[yn].handle);
  wimp_delete_wind(years[yn].handle);
 }


 if(yn<yearn && years)
 {
  if(yearn==1)
  {
   flex_free((flex_ptr)&years);
   years=0;
  }
  else
  {
   flex_midextend((flex_ptr)&years,(yn+1)*sizeof(yearstr),-(signed)sizeof(yearstr));
  }
  yearn--;
 }

 if(years==NULL) pollquit(0);

 return(NULL);
 USE(handle);
}








os_error * newyear(int year)
{
 os_error * err;
// wimp_wind * wp;


 if(!yearn) err=flex_alloc((flex_ptr)&years,sizeof(yearstr)*(yearn+1));
 else       err=flex_extend((flex_ptr)&years,sizeof(yearstr)*(yearn+1));

 if(!err)
 {
  memset(&years[yearn],0,sizeof(yearstr));

//  wp=windpoi[CALENDAR];
//  wp->minsize=((MONTOP+MONBOT+MONHEIGHT)<<16)+(MONLEFT+MONRIGHT+MONWIDTH);

  err=createwindow(TCALENDAR,&years[yearn].handle);
  if(!err)
  {
   err=createwindowparent(TYEAR,&years[yearn].pane,years[yearn].handle);
   err=createwindowparent(TDATES,&years[yearn].dates,years[yearn].handle);

   addclickevent(yearpaneicon,years[yearn].pane,yearn);
   addkeyevent(keyyear,years[yearn].pane,yearn);
   addkeyevent(keymain,years[yearn].handle,yearn);
   addcloseevent(yearclose,years[yearn].handle,yearn);
   addredrawevent(yeardraw,years[yearn].dates,yearn);
   addopenevent(yearopen,years[yearn].handle,yearn);
   setupyear(&years[yearn],year);
   err=extent(years[yearn].handle,0,-(MONTOP+12*MONHEIGHT+11*MONDELTAY+MONBOT),
                                 MONLEFT+12*MONWIDTH+11*MONDELTAX+MONRIGHT,0);

   wimp_setwindowflags(years[yearn].dates,WINDOWAUTOCENTRE,0);
   wimp_setwindowflags(years[yearn].handle,WINDOWMINMAX,0);

   setupyear(&years[yearn],year);
   yearn++;
   yearpopup(yearn-1);
   iecarrot(years[yearn-1].pane,IDC_YEAR_YEAR);
//   setfocus(years[yearn-1].handle);
  }
 }
 return(err);

 USE(year);
}





void popyear(char * year)
{
 os_error  * err;
 struct tm   timem;
 time_t      timex;

 if(year)
 {
  timem.tm_year=atoi(year);
 }
 else
 {
  timex=time(NULL);
  timem=*localtime(&timex);
  timem.tm_year+=1900;
 }

 err=newyear(timem.tm_year);

 if(err) report(err);
}




void inityear(void)
{
 years=NULL;
 yearn=0;
}


/*****************************************************************************/



void terminate(void)
{
 event(EVENT_ENDPROGRAM,NULL,0);
 report(finittask());
}



static os_error * terminatemessage(wimp_msgstr * msg,int * ack)
{
 terminate();
 USE(msg);
 USE(ack);
 return(NULL);
}




static os_error * addmessages(void)
{
 os_error * err;

 err=addmessage(terminatemessage,wimp_MCLOSEDOWN);

 return(err);
}






int main(int argc,char * argv[])
{ 
 os_error * err;

 setlocale(LC_ALL,".1252");

 err=inittask("Calendar","Calendar","!Calendar",NULL,NULL,NULL);
 if(err)
 {
  report(err);
  exit(0);
 }

 cprintf("main point2");

#ifdef __DEBUG
 debugenable(NULL); 
#endif

 cprintf("point2a");

// resinit

  resinit(NULL);

  addmessages();



// if(!err) err=menulostart("<SyncDiscsRes$Dir>","Menus");

  if(err) cprintf("point 2c");



 event(EVENT_RUNPROGRAM,NULL,0);

 if(err)
 {
  report(err);
  terminate();
 }

 inityear();

 popyear(argc>1?argv[1]:NULL);

// cprintf("xdpi %d ydpi %d",cvdu.xdpi,cvdu.ydpi);

 runtask();

 return(0);
}



