
#include <stdio.h>

#include <SerialCommand.h>


#include <AccelStepper.h>


#ifdef __AVR__
#include <avr/signature.h>
#endif 

// Pin 13 has an LED connected on most Arduino boards.
// give it a name:
int led = 13;
int pin_enable = 12;
int pin_step=7;
int pin_direction=8;
int pin_ms0=9;
int pin_ms1=10;
int pin_ms2=11;
int pin_input2=2;
int pin_input3=3;

int pin_relay4=4;
int pin_relay5=5;
int pin_relay6=6;


int timode=0;
int basesize=16;

int currentstepsize=1;
int pendingstepsize=1;
int pendingstepsizechange=0;
//int stepmultiplier=basesize/currentstepsize;
long stepspeed=16000;
long stepacceleration=8000;

long runspeed;



int movestarted=0;

long movetime=0;
long movedistance=0;

long currentbaseposition=0;

int loopcount=0;
int loopstep=1;
int loopphase=0;

char pattern1[8]={1,1,1,1,0,0,0,0};
char pattern2[8]={1,0,0,1,0,0,0,0};
char * pattern=pattern1;




AccelStepper stepper(1, pin_step, pin_direction);

SerialCommand sCmd;

void poweron()
{
 pattern=pattern2;
 digitalWrite(pin_enable,LOW);   
 delay(25);
}

void poweroff()
{
 pattern=pattern1; 
 delay(25);
 digitalWrite(pin_enable,HIGH);   
}


int powermode=2;

void powerauto()
{
 if(powermode==2 && pattern==pattern2)
 {
  poweroff();
 } 
} 


// pw,0 off
// pw,1 on
// p2,2 auto

void cmdpower()
{
 char * arg; 

 arg = sCmd.next();
 if(arg!=NULL)
 {
  powermode=atoi(arg);

//  Serial.print("First argument was: ");
//  Serial.println(powermode);  

  if(powermode==0) poweroff();
  else
  if(powermode==1) poweron();
  else
  {
   powermode=2;  
   poweroff(); 
  }  
 }  
}


// mv <steps>

void cmdmove()
{
 char * arg; 
 long   steps;
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  steps=atol(arg);
//  Serial.print("move First argument was: ");
//  Serial.println(steps); 
  poweron();
  flushstepsizechange(steps);
//  steps/=stepmultiplier;  stepmultiplier=basesize/currentstepsize;

  steps=(steps*currentstepsize)/basesize;

  stepper.move(steps);
  movestarted=1;

  movetime=millis();
  movedistance=steps;
 }  
}



void cmdmoveto()
{
 char * arg; 
 long   steps;
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  steps=atol(arg);
  steps-=currentbaseposition;
//  Serial.print("First argument was: ");
//  Serial.println(steps);  
  poweron();

//  flushstepsizechange(steps-stepper.currentPosition()*stepmultiplier); stepmultiplier=basesize/currentstepsize;
  flushstepsizechange(steps-(stepper.currentPosition()*basesize)/currentstepsize);
  
//  steps/=stepmultiplier; stepmultiplier=basesize/currentstepsize;
  steps=(steps*currentstepsize)/basesize;
  stepper.moveTo(steps);
  movestarted=1;

 }  
}




// sp <steps per second>

void  cmdspeed()
{
 char * arg; 


 arg = sCmd.next();
 if(arg!=NULL)
 {
  stepspeed=atol(arg);
//  Serial.print("First argument was: ");
//  Serial.println(sspeed);  

 } 
}  




void runspeedclear()
{
 runspeed=0; 
 poweroff(); 
 stepper.setCurrentPosition(stepper.currentPosition());    
}  

void  cmdrunspeed()
{
 char * arg; 
 long   newspeed;
 arg = sCmd.next();
 if(arg!=NULL)
 {
  newspeed=atol(arg);
  if(newspeed==0)
  {
   runspeedclear();
  }
  else
  {
   if(runspeed==0) poweron();    
   runspeed=newspeed; 
   flushstepsizechange(runspeed);
   //stepmultiplier=basesize/currentstepsize;
   //stepper.setMaxSpeed(abs(runspeed/stepmultiplier));   
   //stepper.setSpeed(runspeed/stepmultiplier);
   
   stepper.setMaxSpeed(abs((runspeed*currentstepsize)/basesize));   
   stepper.setSpeed((runspeed*currentstepsize)/basesize);
  } 
  
//  Serial.print("rs ");
//  Serial.println(runspeed/stepmultiplier);
 } 
}  




// ac,<steps per second per second>

void cmdacceleration()
{
 char * arg; 
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  stepacceleration=atol(arg);
//  Serial.print("First argument was: ");
//  Serial.println(sacc);  

 } 
}  


void cmdstop()
{
 char * arg; 
 
 arg = sCmd.next();

 stepper.stop();
}



void  cmdsetpos()
{
 char * arg; 
 long   pos;
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
//   
//  currentbaseposition=atol(arg)-stepper.currentPosition()*stepmultiplier;
//int stepmultiplier=basesize/currentstepsize;
  currentbaseposition=atol(arg)-(stepper.currentPosition()*basesize)/currentstepsize;
//  Serial.print("First argument was: ");
//  Serial.println(pos);
//  pos/=stepmultiplier;
//  stepper.setCurrentPosition(pos);
 } 
}  





// ss,<number of microsteps 1,2,4,8,16>


void setupstepsize(int msteps)
{
  
  if(msteps==1)
  {
   digitalWrite(pin_ms0,LOW);
   digitalWrite(pin_ms1,LOW);
   digitalWrite(pin_ms2,LOW);
  }
  else
  if(msteps==2)
  {
   digitalWrite(pin_ms0,HIGH);
   digitalWrite(pin_ms1,LOW);
   digitalWrite(pin_ms2,LOW);
  }
  else
  if(msteps==4)
  {
   digitalWrite(pin_ms0,LOW);
   digitalWrite(pin_ms1,HIGH);
   digitalWrite(pin_ms2,LOW);
  }
  else  
  if(msteps==8)
  {
   digitalWrite(pin_ms0,HIGH);
   digitalWrite(pin_ms1,HIGH);
   digitalWrite(pin_ms2,LOW);
  }
  else
  if(msteps==16)
  {
   if(timode)
   {
    digitalWrite(pin_ms0,LOW);
    digitalWrite(pin_ms1,LOW);
   }
   else
   {
    digitalWrite(pin_ms0,HIGH);
    digitalWrite(pin_ms1,HIGH);
   } 
   digitalWrite(pin_ms2,HIGH);
  }  
  else
  if(msteps==32)
  {
   digitalWrite(pin_ms0,HIGH);
   digitalWrite(pin_ms1,HIGH);
   digitalWrite(pin_ms2,HIGH);
  }  
}  

void flushstepsizechange(long steps)
{
 if(pendingstepsizechange)
 {
  if(currentstepsize>pendingstepsize)
  {
   // problem, going from small steps to bigger ones
   long currentpos=stepper.currentPosition();
   long newpos;
   
   if(steps>=0) newpos=((currentpos+(currentstepsize-1)/2)*pendingstepsize)/currentstepsize;
   else         newpos=(currentpos*pendingstepsize)/currentstepsize;

//   Serial.print("cur ");   
//   Serial.print(currentpos);   
//   Serial.print("new ");      
//   Serial.println(newpos);      
   
   stepper.runToNewPosition(newpos*(currentstepsize/pendingstepsize));
  } 

  stepper.setCurrentPosition((stepper.currentPosition()*pendingstepsize)/currentstepsize);  
  setupstepsize(pendingstepsize);
  currentstepsize=pendingstepsize;
  pendingstepsizechange=0;
//  stepmultiplier=basesize/currentstepsize;
 }
//int stepmultiplier=basesize/currentstepsize;
// stepper.setMaxSpeed(stepspeed/stepmultiplier);
// stepper.setAcceleration(stepacceleration/stepmultiplier);  
 stepper.setMaxSpeed((stepspeed*currentstepsize)/basesize);
 stepper.setAcceleration((stepacceleration*currentstepsize)/basesize);  
}  


void cmdstepsize()
{
 char * arg; 
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  pendingstepsize=atoi(arg);
  pendingstepsizechange=1;
//  Serial.print("First argument was: ");
//  Serial.println(msteps);  

 } 
}  



void cmdcurrentposition()
{
  
// Serial.print("ps "); 
 //int stepmultiplier=basesize/currentstepsize;
//  Serial.println(stepper.currentPosition()*stepmultiplier+currentbaseposition); 
// Serial.println((stepper.currentPosition()*basesize)/currentstepsize+currentbaseposition); 
 Serial.println("ps "+String((stepper.currentPosition()*basesize)/currentstepsize+currentbaseposition));
}  


void cmddistancetogo()
{
 Serial.print("ds "); 
 //int stepmultiplier=basesize/currentstepsize;
// Serial.println(stepper.distanceToGo()*stepmultiplier); 
  Serial.println((stepper.distanceToGo()*basesize)/currentstepsize); 
}  


void cmdreadpin()
{
 char * arg;
 int    rpin; 
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  rpin=atoi(arg);
  
  Serial.print("rd "); 
  Serial.println(digitalRead(rpin)); 
 }
}  


void cmdwritepin()
{
 char * arg;
 int    wpin; 
 int    val;
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  wpin=atoi(arg);

  arg = sCmd.next();
  if(arg!=NULL)
  {
   val=atoi(arg);
   
   digitalWrite(wpin,val); 
  } 
 }
}  



static inline boolean attachInterruptToPin(uint8_t pin, void (*userFunc)(void), int mode)
{
 int irq = digitalPinToInterrupt(pin);
 if (irq == NOT_AN_INTERRUPT)
   return false;
 attachInterrupt(irq, userFunc, mode);
 return true;
}


static inline boolean detachInterruptFromPin(uint8_t pin)
{
  int irq = digitalPinToInterrupt(pin);
  if (irq == NOT_AN_INTERRUPT)
    return false;
  detachInterrupt(irq);
  return true;
}




volatile long interrupt2time;
volatile long interrupt3time;
volatile int  interruptflag=0;
volatile int  interruptdelay=3;

int interruptmisses=0;

void interrupt2()
{
 if((interruptflag & 0xF)==1)
 {
  interruptflag&=0xF0;
  interruptflag|=2;
  interrupt2time=millis();
  interruptmisses++;
 } 
}


void interrupt3()
{
 if((interruptflag & 0xFF)==0x10)
 {
  interruptflag&=0xF;
  interruptflag|=0x20;
  interrupt3time=millis();
  interruptmisses++;  
 } 
}


void cleanupinterrupt()
{
  int stopflag=0;

  noInterrupts();

  if((interruptflag & 0xF0)==0x20)
  {
   if(digitalRead(3)==0)
   {
    if((millis()-interrupt3time)>=interruptdelay)
    {
     detachInterruptFromPin(3);    
     interruptflag&=0xF;
     stopflag=1;
    } 
   }
   else
   { // reset interrupt
    interruptflag&=0xF;
    interruptflag|=0x10;
   }  
  }
  
  if((interruptflag & 0xF)==0x2)
  {
   if(digitalRead(2)==0)
   {
    if((millis()-interrupt2time)>=interruptdelay)
    {
     detachInterruptFromPin(2);    
     interruptflag&=0xF0;
     stopflag=1;
    } 
   }
   else
   { // reset interrupt
    interruptflag&=0xF0;
    interruptflag|=1;
   }  
  }

  interrupts();
  
  if(stopflag)
  {
   if(runspeed)
   {
    runspeedclear();
   }
   else
  {
   stepper.stop();    
  } 
 }
}  





void cmdarminterrupt() // interrupt 0,1 mode
{
 char * arg;
 int    interruptn; 
 int    val;
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  interruptn=atoi(arg);

  arg = sCmd.next();
  if(arg!=NULL)
  {
   val=atoi(arg);
  
   if(interruptn==0)
   {
    attachInterruptToPin(2,interrupt2,val);
    interruptflag&=0xF0;
    interruptflag|=0x1;
   }
   
   if(interruptn==1)
   {
    attachInterruptToPin(3,interrupt3,val);
    interruptflag&=0xF;
    interruptflag|=0x10;
   }
   interruptmisses=0;
  }
 } 
}  


 

void cmdreminterrupt()
{
 char * arg;
 int    interruptn; 
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  interruptn=atoi(arg);

  if((interruptflag & 0xF)==1)
  {
   detachInterruptFromPin(2);
   interruptflag&=0xF0;    
  }
   
  if((interruptflag & 0xF0)==0x10)
  {
   detachInterruptFromPin(3);
   interruptflag&=0xF;    
  } 
 } 
}  



void cmddebinterrupt()
{
 char * arg;
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  interruptdelay=atoi(arg);
 } 
}  







void cmdinterruptstate()
{
 Serial.print("is ");
 Serial.print(interruptflag,BIN);
 Serial.print(" misses ");
 Serial.println(interruptmisses); 
 
}  


 
void cmdunrecognized(const char *command)
{
 Serial.println("What?"); 
}  




void cmdversion()
{
 Serial.println( "Version: 1.12 20/11/2014 Compiled: "  __TIMESTAMP__ ", " __VERSION__); 
} 


void cmdtimode()
{
 char * arg; 
 
 arg = sCmd.next();
 if(arg!=NULL) timode=atoi(arg);
 else          timode=1;

 if(timode==0)
 {
  if(currentstepsize==32)
  {
   pendingstepsizechange=1;
   pendingstepsize=16;
  }
 } 
}  


void cmdbasesize()
{
 char * arg; 
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  basesize=atoi(arg); 
 }
}  



long  delaytime;

void cmddelay()
{
 char * arg;

//  Serial.println("delay1");
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  delaytime=millis()+atol(arg);
//  Serial.println("delay");
 }
}


int runcode=0;

char * program[]={NULL,"ss 16","sp 32","mv 8","dl 5000","wr 4 1","dl 200","wr 4 0","dl 5000",NULL};

void runcodepoll()
{
 if(millis()>delaytime)
 {
//  Serial.println(program[runcode]); 
  if(sCmd.exec(program[runcode])==0)
  {
   runcode++;
   if(program[runcode]==NULL) runcode=1;
//   if(runcode==5) runcode=0;
  } 
 } 
}  


void cmdruncode()
{
 char * arg;
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  delaytime=0; 
  runcode=atoi(arg);
 } 
}


void cmdtest()
{
 char * arg;
 int    pin;
 int    result=1;
 int    result1;
 int    result2;
 
 arg = sCmd.next();
 if(arg!=NULL)
 {
  pin=atoi(arg);
  if(pin==pin_input2 || pin==pin_input3)
  {
//  Serial.print("testing sensor on pin ");
//   Serial.println(pin);
   pinMode(pin,INPUT);
   result1=digitalRead(pin); // expect 0 for no sensor
//   Serial.print("Test 1, expected result is 0 for no sensor got ");
//   Serial.println(result1);
   pinMode(pin,INPUT_PULLUP);
   delay(5);
   result2=digitalRead(pin); // expect 1 for no sensor
//   Serial.print("Test 2, expected result is 1 for no sensor got ");
//   Serial.println(result2);
   pinMode(pin,INPUT); 
 
   if(result1==result2) result=0;
//   Serial.println("If the above two results are equal then return 0 (sensor present) else return 1");
  }
 } 

 Serial.print("ts ");
 Serial.println(result); 
}  


/*
The first byte (0x1e) indicates ATMEL manufactured the chip.
The second byte indicates the amount of flash memory on the chip (0×94 = 16K, 0×95 = 32K, etc.).
The third byte indicates the µC processor.


*/


// pr 0x1e950f


void cmdprocessor()
{
 #ifdef __AVR__
 char temp[32];
 sprintf(temp,"pr 0x%02x%02x%02x",SIGNATURE_0,SIGNATURE_1,SIGNATURE_2); 
 Serial.println(temp);
 #else
 Serial.println("pr 0xFFFFFFFF"); 
 #endif
}  


// the setup routine runs once when you press reset:
void setup() 
{                
  // initialize the digital pin as an output.
  pinMode(led, OUTPUT);

  pinMode(pin_enable,OUTPUT);
  poweroff();

  pinMode(pin_direction,OUTPUT);
  pinMode(pin_step,OUTPUT);
  
  pinMode(pin_ms0,OUTPUT);
  pinMode(pin_ms1,OUTPUT);
  pinMode(pin_ms2,OUTPUT);
  
  setupstepsize(1);
  
  pinMode(pin_input2,INPUT);
  pinMode(pin_input3,INPUT);


  pinMode(pin_relay4,OUTPUT);
  pinMode(pin_relay5,OUTPUT);
  pinMode(pin_relay6,OUTPUT);
  digitalWrite(pin_relay4,LOW);
  digitalWrite(pin_relay5,LOW);  
  digitalWrite(pin_relay6,LOW);


  
  Serial.begin(9600);
//  SerialUSB.begin(9600);

  sCmd.addCommand("pw",cmdpower);

  sCmd.addCommand("mv",cmdmove); 
  sCmd.addCommand("mt",cmdmoveto);   
  
  sCmd.addCommand("sp",cmdspeed);
  sCmd.addCommand("ac",cmdacceleration);
 
  sCmd.addCommand("ss",cmdstepsize);
  sCmd.addCommand("xx",cmdstop);
  sCmd.addCommand("ps",cmdcurrentposition);  
  sCmd.addCommand("ds",cmddistancetogo);
  sCmd.addCommand("rd",cmdreadpin);
  sCmd.addCommand("wr",cmdwritepin);
  sCmd.addCommand("ai",cmdarminterrupt);  
  sCmd.addCommand("is",cmdinterruptstate);  
  sCmd.addCommand("sc",cmdsetpos);
  
  sCmd.addCommand("rs",cmdrunspeed);
  
  sCmd.addCommand("ve",cmdversion);  
  
  sCmd.addCommand("ri",cmdreminterrupt);    
  sCmd.addCommand("ti",cmdtimode);    
  sCmd.addCommand("di",cmddebinterrupt);

  sCmd.addCommand("dl",cmddelay);
  sCmd.addCommand("rc",cmdruncode);
  sCmd.addCommand("bs",cmdbasesize);
  
  sCmd.addCommand("ts",cmdtest);

  sCmd.addCommand("pr",cmdprocessor);
  
  sCmd.setDefaultHandler(cmdunrecognized);  
}





//int loopcheck=0;
//int looptime=0;

// the loop routine runs over and over again forever:
void loop()
{

 if(interruptflag & 0x22)
 {
  cleanupinterrupt(); 
 }

 if(Serial.available()>0) 
 {
  //    Serial.println("serial");
  sCmd.readSerial();
 }
 else
 if(runspeed)
 {
  stepper.runSpeed();  
 }
 else 
 if(stepper.distanceToGo()!=0)
 {
//  Serial.println("step run");
  stepper.run();
/*  
  loopcheck++;
  if(loopcheck>1000)
  {
   Serial.println(millis()-looptime);
   loopcheck=0;
   looptime=millis();
  }  
*/  
 }
 else 
 {
  if(movestarted)
  {
   movestarted=0;
   if(!runcode)
   {
    Serial.print("mv ");
    //int stepmultiplier=basesize/currentstepsize;
//    Serial.print(currentbaseposition+stepper.currentPosition()*stepmultiplier);
    Serial.print(currentbaseposition+(stepper.currentPosition()*basesize)/currentstepsize);
    Serial.print(" ");
    Serial.println(powermode);
   } 
   {
/*    long duration=millis()-movetime; 
    Serial.print("time ");
    Serial.print(duration);
    Serial.print(" steps per second ");
    Serial.println((movedistance*1000)/duration);    */
   }   
  }
  else
  {
   powerauto();
   loopcount++;
   if(loopcount>20000)
   {
    loopcount=0;
    digitalWrite(led, pattern[loopphase]);   // turn the LED on (HIGH is the voltage level)
    loopphase++;
    if(loopphase>7) loopphase=0;
   }  
   
   if(runcode)
   {
    runcodepoll(); 
   }  
   
  } 
 }
}

